<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Setting;
use App\Models\Order;

use Illuminate\Support\Str;

class CheckoutURLController extends Controller
{
    private $base_url;

    public function __construct()
    {
        // Sandbox
        //$this->base_url = 'https://tokenized.sandbox.bka.sh/v1.2.0-beta';
        // Live
        $this->base_url = 'https://tokenized.pay.bka.sh/v1.2.0-beta';
    }

    public function authHeaders()
    {
        return array(
            'Content-Type:application/json',
            'Authorization:' . $this->grant(),
            'X-APP-Key:' . env('BKASH_CHECKOUT_URL_APP_KEY')
        );
    }

    public function curlWithBody($url, $header, $method, $body_data_json)
    {
        $curl = curl_init($this->base_url . $url);
        curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, $method);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $body_data_json);
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($curl, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
        $response = curl_exec($curl);
        curl_close($curl);
        return $response;
    }

    public function grant()
    {
        $header = array(
            'Content-Type:application/json',
            'username:' . env('BKASH_CHECKOUT_URL_USER_NAME'),
            'password:' . env('BKASH_CHECKOUT_URL_PASSWORD')
        );
        $header_data_json = json_encode($header);

        $body_data = array('app_key' => env('BKASH_CHECKOUT_URL_APP_KEY'), 'app_secret' => env('BKASH_CHECKOUT_URL_APP_SECRET'));
        $body_data_json = json_encode($body_data);

        $response = $this->curlWithBody('/tokenized/checkout/token/grant', $header, 'POST', $body_data_json);

        $token = json_decode($response)->id_token;

        return $token;
    }

    public function payment(Request $request)
    {
        return view('CheckoutURL.pay');
    }

    public function createPayment(Request $request)
    {
        if ($request->has('order_id')) {
            $id = $request->has('order_id');
            $order = Order::findOrfail($id);
            $amount = $order->total_amount;
            $settings = Setting::where('id', 1)->first();
            if ($order) {
                $header = $this->authHeaders();

                $website_url = URL::to("/");

                $body_data = array(
                    'mode' => '0011',
                    'payerReference' => ' ',
                    'callbackURL' => $website_url . '/bkash/callback',
                    'amount' => $amount ? $amount : 10,
                    'currency' => 'BDT',
                    'intent' => 'sale',
                    'merchantInvoiceNumber' => $settings->order_prefix . $order->id // you can pass here OrderID 
                );
                $body_data_json = json_encode($body_data);

                $response = $this->curlWithBody('/tokenized/checkout/create', $header, 'POST', $body_data_json);

                return redirect((json_decode($response)->bkashURL));
            } else {
                request()->session()->flash('error', 'Order not found!!');
                return redirect()->back();
            }
        } else {
            request()->session()->flash('error', 'Please try again!!');
            return redirect()->back();
        }
    }

    public function executePayment($paymentID)
    {

        $header = $this->authHeaders();

        $body_data = array(
            'paymentID' => $paymentID
        );
        $body_data_json = json_encode($body_data);

        $response = $this->curlWithBody('/tokenized/checkout/execute', $header, 'POST', $body_data_json);

        $res_array = json_decode($response, true);

        if (isset($res_array['trxID'])) {
            // your database insert operation
            // save $response

        }

        return $response;
    }

    public function queryPayment($paymentID)
    {

        $header = $this->authHeaders();

        $body_data = array(
            'paymentID' => $paymentID,
        );
        $body_data_json = json_encode($body_data);

        $response = $this->curlWithBody('/tokenized/checkout/payment/status', $header, 'POST', $body_data_json);

        $res_array = json_decode($response, true);

        if (isset($res_array['trxID'])) {
            // your database insert operation
            // insert $response to your db

        }

        return $response;
    }

    public function callback(Request $request)
    {
        $allRequest = $request->all();
        if (isset($allRequest['status']) && $allRequest['status'] == 'failure') {
            return view('CheckoutURL.fail')->with([
                'response' => 'Payment Failure'
            ]);
        } else if (isset($allRequest['status']) && $allRequest['status'] == 'cancel') {
            return view('CheckoutURL.fail')->with([
                'response' => 'Payment Cancell'
            ]);
        } else {

            $response = $this->executePayment($allRequest['paymentID']);

            $arr = json_decode($response, true);

            if (array_key_exists("statusCode", $arr) && $arr['statusCode'] != '0000') {
                return view('CheckoutURL.fail')->with([
                    'response' => $arr['statusMessage'],
                ]);
            } else if (array_key_exists("message", $arr)) {
                // if execute api failed to response
                sleep(1);
                $query = $this->queryPayment($allRequest['paymentID']);
                return view('CheckoutURL.success')->with([
                    'response' => $query
                ]);
            }

            return view('CheckoutURL.success')->with([
                'response' => $response
            ]);
        }
    }

    public function getRefund(Request $request)
    {
        return view('CheckoutURL.refund');
    }

    public function refundPayment(Request $request)
    {
        $header = $this->authHeaders();

        $body_data = array(
            'paymentID' => $request->paymentID,
            'amount' => $request->amount,
            'trxID' => $request->trxID,
            'sku' => 'sku',
            'reason' => 'Quality issue'
        );

        $body_data_json = json_encode($body_data);

        $response = $this->curlWithBody('/tokenized/checkout/payment/refund', $header, 'POST', $body_data_json);

        // your database operation
        // save $response

        return view('CheckoutURL.refund')->with([
            'response' => $response,
        ]);
    }
}
